/**
 * 
 */
package gov.va.med.mhv.integration.phr.service;

import gov.va.med.mhv.integration.phr.dao.TransferDAO;
import gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageType;
import gov.va.med.mhv.integration.phr.stage.transfer.StageMessageControl;
import gov.va.med.mhv.integration.phr.transfer.QueryRequest;

import java.util.Date;

/**
 * @author DNS
 * 
 *         Base class for containing common Query Service methods and
 *         properties.
 */
public abstract class BaseQueryService implements QueryService {

	protected StagingService stagingService = null;
	
	protected TransferDAO transferDAO = null;
	
	protected String defaultStartDate = "19840101";
	
	protected Boolean ignoreIcnCheck = true;

	protected abstract StageMessageControl doQuery(QueryRequest request, QueryServiceResponse result);

	public QueryServiceResponse process(QueryRequest request) {

		QueryServiceResponse result = new QueryServiceResponse(
				QueryServiceResponse.OK);
		Date queryStartTime = new Date();

		StageMessageControl stageMessage = null;

		// update the extract log with the progress
		try {
			stageMessage = doQuery(request, result);
			
			// update the response message and track the progress
			stageMessage.setMessageStatus(result.getStatus());
			stageMessage.setMessageName(DataService.messageName);
			stageMessage.setCreatedDate(queryStartTime);
			
			// include the status and any error message if the extract status is 'ERROR' information
			stageMessage.setExtractStatus(result.getStatus());
			if ("ERROR".equalsIgnoreCase(stageMessage.getExtractStatus())) {
				stageMessage.setErrorMessage(result.getDescription());
			}
			
			stageMessage.setEndDate(new Date());
			
		} catch (Exception ex) {
			result.setStatus(QueryServiceResponse.ERROR);
			result.setDescription(String.format("Error staging message status: %s", ex.getMessage()));
			
			if( stageMessage != null )
			{
				stageMessage.setExtractStatus(result.getStatus());
				stageMessage.setErrorMessage(result.getDescription());
			}
		} finally {
			if( stageMessage != null )
			{
				this.stagingService.stageRequest(stageMessage);
			}
		}
		

		return result;
	}
	
	public StageMessageControl getResponseMessage(QueryRequest request,
			QueryServiceResponse processingResult, String routingStatus) {

		StageMessageControl responseMessage = this.stagingService
				.findLatestStagingRequest(request.getIcn(),
						request.getStationNumber(),
						RefreshDataService.messageName,
						request.getExtractType());

		if (responseMessage == null) {
			responseMessage = new StageMessageControl(DataService.messageName,
					(long) processingResult.getRecordCount(), routingStatus,
					StageMessageType.RESPONSE, request.getIcn(),
					request.getStationNumber(), request.getExtractType(),
					request.getStartDate(), request.getEndDate());
		}

		// initiate the response message control identifier from the request.
		responseMessage.setRequestMsgCtrlId(request.getRequestMsgCtrlId());

		// setup a request id if none was provided
		if (request.getRequestMsgCtrlId() == 0)
			responseMessage.setRequestMsgCtrlId(responseMessage.getId());

		responseMessage.setResponseMsgCtrlId(responseMessage.getId());

		return responseMessage;
	}

	public void setStagingService(StagingService stagingService) {
		this.stagingService = stagingService;
	}
	
	public void setTransferDAO(TransferDAO transferDAO) {
		this.transferDAO = transferDAO;
	}
	
	public String getDefaultStartDate() {
		return defaultStartDate;
	}
	
	public void setDefaultStartDate(String defaultStartDate) {
		this.defaultStartDate = defaultStartDate;
	}
	
	public Boolean ignoreIcnCheck() 
	{
		return this.ignoreIcnCheck;
	}
	
	public void setIgnoreIcnCheck(Boolean ignoreIcnCheck) {
		this.ignoreIcnCheck = ignoreIcnCheck;
	}
}
